/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoSort;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class JCoFileTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private Icon m_directoryIcon = null;
    private Icon m_fileIcon = null;
    private Icon m_qdIcon = null;
    private CoFile[] m_files = new CoFile[0];
    private CoFile[] m_origfiles = new CoFile[0];
    private int m_orderI = 1;
    private String[] m_filterS = new String[0];
    private String[] m_specialTypes = new String[]{".FMT", ".IMG", ".SEQ", ".JPG", ".PNG", ".BMP", ".CMD", ".LIB", ".XML", ".INI", ".O"};
    private final DefaultTableCellRenderer m_renderer = new DefaultTableCellRenderer(){
        private static final long serialVersionUID = 1L;

        public void setValue(Object object) {
            if (object instanceof CoFile) {
                CoFile coFile = (CoFile)object;
                Icon icon = coFile.isDirectory() ? JCoFileTable.this.m_directoryIcon : (coFile.equalsExtTo(JCoFileTable.this.m_specialTypes) ? JCoFileTable.this.m_qdIcon : JCoFileTable.this.m_fileIcon);
                this.setIcon(icon);
                this.setText(coFile.getName());
            } else {
                super.setValue(object);
            }
        }
    };
    private final AbstractTableModel m_model = new AbstractTableModel(){
        private static final long serialVersionUID = 1L;
        String[] m_names = new String[]{"File Name", "Size", "Last Modified"};

        public int getColumnCount() {
            return this.m_names.length;
        }

        public int getRowCount() {
            return JCoFileTable.this.m_files.length;
        }

        public Object getValueAt(int n, int n2) {
            Object object;
            switch (n2) {
                case 0: {
                    object = JCoFileTable.this.m_files[n];
                    break;
                }
                case 1: {
                    object = new Integer((int)JCoFileTable.this.m_files[n].length());
                    break;
                }
                case 2: {
                    object = JCoFileTable.this.m_files[n].lastModifiedString();
                    break;
                }
                default: {
                    object = "";
                }
            }
            return object;
        }

        public String getColumnName(int n) {
            return this.m_names[n];
        }
    };

    public JCoFileTable(Icon icon) {
        this.setModel(this.m_model);
        TableColumn tableColumn = this.getColumn("File Name");
        tableColumn.setCellRenderer(this.m_renderer);
        this.m_directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.m_fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.m_qdIcon = icon;
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int[] nArray = JCoFileTable.this.getSelectedRows();
                if (keyEvent.getModifiers() != 1) {
                    int n;
                    int n2 = n = nArray.length > 0 ? nArray[nArray.length - 1] + 1 : 0;
                    while (n < JCoFileTable.this.m_files.length) {
                        if (JCoFileTable.this.m_files[n].startsWithIgnoreCase(c)) {
                            JCoFileTable.this.setSelectedFile(JCoFileTable.this.m_files[n]);
                            return;
                        }
                        ++n;
                    }
                    for (n = 0; n < JCoFileTable.this.m_files.length; ++n) {
                        if (!JCoFileTable.this.m_files[n].startsWithIgnoreCase(c)) continue;
                        JCoFileTable.this.setSelectedFile(JCoFileTable.this.m_files[n]);
                        return;
                    }
                } else {
                    int n;
                    int n3 = n = nArray.length > 0 ? nArray[nArray.length - 1] - 1 : 0;
                    while (n >= 0) {
                        if (JCoFileTable.this.m_files[n].startsWithIgnoreCase(c)) {
                            JCoFileTable.this.setSelectedFile(JCoFileTable.this.m_files[n]);
                            return;
                        }
                        --n;
                    }
                    for (n = JCoFileTable.this.m_files.length - 1; n >= 0; --n) {
                        if (!JCoFileTable.this.m_files[n].startsWithIgnoreCase(c)) continue;
                        JCoFileTable.this.setSelectedFile(JCoFileTable.this.m_files[n]);
                        return;
                    }
                }
            }
        });
    }

    public CoFile[] getFiles() {
        return this.m_origfiles;
    }

    public void setFiles(CoFile[] coFileArray) {
        this.m_origfiles = coFileArray == null ? new CoFile[0] : coFileArray;
        this.m_files = CoSort.listSplit(CoSort.listOrder(CoSort.listFilter(this.m_origfiles, this.m_filterS), this.m_orderI));
        this.setEnabled(this.m_files.length > 0);
        this.m_model.fireTableDataChanged();
    }

    public CoFile getSelectedFile() {
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length == 1 && nArray[0] >= 0 && nArray[0] < this.m_files.length) {
            return this.m_files[nArray[0]];
        }
        return null;
    }

    public void setSelectedFile(CoFile coFile) {
        this.clearSelection();
        for (int i = 0; i < this.m_files.length; ++i) {
            if (!this.m_files[i].equals(coFile)) continue;
            this.addRowSelectionInterval(i, i);
            break;
        }
    }

    public CoFile[] getSelectedFiles() {
        int[] nArray = this.getSelectedRows();
        CoFile[] coFileArray = new CoFile[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            coFileArray[i] = this.m_files[nArray[i]];
        }
        return coFileArray;
    }

    public void setSelectedFiles(CoFile[] coFileArray) {
        this.clearSelection();
        block0: for (int i = 0; i < coFileArray.length; ++i) {
            for (int j = 0; j < this.m_files.length; ++j) {
                if (!this.m_files[j].equals(coFileArray[i])) continue;
                this.addRowSelectionInterval(j, j);
                continue block0;
            }
        }
    }

    public void deselectAllFiles() {
        this.clearSelection();
    }

    public void setOrder(int n) {
        this.m_orderI = n;
        this.setFiles(this.m_origfiles);
    }

    public void setFilter(String[] stringArray) {
        this.m_filterS = stringArray;
        this.setFiles(this.m_origfiles);
    }

    static class NullAction
    implements Action {
        Action m_delegate;
        boolean m_setOnce = false;

        public NullAction(JTable jTable, Action action) {
            this.m_delegate = action;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.m_delegate.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.m_delegate.removePropertyChangeListener(propertyChangeListener);
        }

        public Object getValue(String string) {
            return this.m_delegate.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.m_delegate.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.m_delegate.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.m_delegate.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

